
/*:

@target MZ
@plugindesc 遠くのイベントも自律移動するようにします。
@author メロウ紙芝居
@url https://meroukamisibai.com/

@help MK_FarEventMove.js

プラグインコマンドで遠くのイベントの自律移動をONにすると、
イベントが遠くても自律移動します。OFFにすると、
遠くのイベントは自律移動をしなくなります。


@command move
@text 遠くのイベントの自律移動
@desc 遠くのイベントが自律移動をするか変更できます。

@arg move
@text 自律移動
@desc 遠くのイベントが自律移動をするか変更できます。
@type boolean
@default true

*/

/////////////////グローバルデータ/////////////////
var mk_farEventMove = null;


/////////////////遠くのイベントの操作データ/////////////////

function MK_FarEventMove() {
    this.move = false;
}

MK_FarEventMove.prototype.Move = function(move) {
    this.move = move;
};


(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_FarEventMove";
    
    //----------プラグインコマンド----------

    //自律移動
    PluginManager.registerCommand(pluginName, "move", args => {
        mk_farEventMove.Move((args.move == "true") ? true : false);
    });
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------イベント関係----------
    
    const _Game_Event_updateSelfMovement = Game_Event.prototype.updateSelfMovement;
    Game_Event.prototype.updateSelfMovement = function() {
        if(mk_farEventMove.move){
           if (!this._locked && this.checkStop(this.stopCountThreshold())){
                switch (this._moveType) {
                    case 1:
                        this.moveTypeRandom();
                        break;
                    case 2:
                        this.moveTypeTowardPlayer();
                        break;
                    case 3:
                        this.moveTypeCustom();
                        break;
                }
            }
        }else{
           _Game_Event_updateSelfMovement.apply(this, arguments);
        }
    };
    
    
    //----------セーブ関係----------
    
    //ゲーム開始時作成データ
    const _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function() {
        _DataManager_createGameObjects.apply(this, arguments);
        mk_farEventMove = new MK_FarEventMove();
    };
    
    //セーブ
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function() {
        let contents = _DataManager_makeSaveContents.apply(this, arguments);
        contents.mk_farEventMove = mk_farEventMove;
        return contents;
    };
    
    //ロード
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function(contents) {
        _DataManager_extractSaveContents.apply(this, arguments);
        mk_farEventMove = contents.mk_farEventMove;
    };
    
})();
